//---------------------------------------------------------------------------------------
//  FILE:    X2TargetingMethod_Singularity_LEBPsi
//  AUTHOR:  LeaderenemyBoss, based on LW2's Flamethrower TargetingMethod by Amineri (Pavonis)
//
//  PURPOSE: New standard AoE targeting method, that only paints valid targets red (why isnt this default behavior?)
//--------------------------------------------------------------------------------------- 

class X2TargetingMethod_Singularity_RMPsi extends X2TargetingMethod_VoidRift;

//`include(PsiOverhaul_LEB\Src\LEBPsiAbilities.uci)

simulated protected function GetTargetedActors(const vector Location, out array<Actor> TargetActors, optional out array<TTile> TargetTiles)
{
	local XComGameStateHistory History;
	//local X2AbilityMultiTarget_Radius MultiTarget;
	local X2AbilityMultiTarget_Radius_RMPsi MultiTarget;
	local AvailableTarget AbilityTarget;
	local StateObjectReference Target;
	local XComGameState_BaseObject TargetState, SourceState;
	local bool bSuccess;
	local X2Condition Condition;

	History = `XCOMHISTORY;
	MultiTarget = X2AbilityMultiTarget_Radius_RMPsi(Ability.GetMyTemplate().AbilityMultiTargetStyle);
	if (MultiTarget == none)
	{
		return;
	}
	//MultiTarget.ResetCache = true;
	MultiTarget.GetMultiTargetsForLocation(Ability, Location, AbilityTarget);

	foreach AbilityTarget.AdditionalTargets(Target)
	{
		TargetState = History.GetGameStateForObjectID(Target.ObjectID);
		SourceState = History.GetGameStateForObjectID(Ability.OwnerStateObject.ObjectID);

		if (TargetState != none && SourceState != none)
		{
			bSuccess = true;

			foreach Ability.GetMyTemplate().AbilityMultiTargetConditions(Condition)
			{
				If (Condition.MeetsCondition(TargetState) != 'AA_Success') bSuccess = false;
				If (Condition.MeetsConditionWithSource(TargetState, SourceState) != 'AA_Success') bSuccess = false;
			}
			
			//`LEBMSG("Target:" @XComGamestate_Unit(TargetState).GetFullName()@"passed check:" @bSuccess);
			If (bSuccess) TargetActors.AddItem(TargetState.GetVisualizer());
		}
	}
	MultiTarget.GetValidTilesForLocation(Ability, Location, TargetTiles);
}